(function($){
    $.fn.validationEngineLanguage = function(){
    };
    $.validationEngineLanguage = {
        newLang: function(){
            $.validationEngineLanguage.allRules = {
                "required": { // Add your regex rules here, you can take telephone as an example
                    "regex": "none",
                    "alertText": "* ঘরটি অবশ্যই পূরণ করতে হবে",
                    "alertTextCheckboxMultiple": "* একটি বিকল্প নির্বাচন করুন",
                    "alertTextCheckboxe": "* এই চেকবক্স প্রয়োজন",
                    "alertTextDateRange": "* উভয় তারিখ পরিসীমা ক্ষেত্র প্রয়োজন"
                },
                "requiredInFunction": { 
                    "func": function(field, rules, i, options){
                        return (field.val() == "test") ? true : false;
                    },
                    "alertText": "* মাঠ অবশ্যই সমান পরীক্ষা"
                },
                "dateRange": {
                    "regex": "none",
                    "alertText": "* অবৈধ",
                    "alertText2": "তারিখের পরিসীমা"
                },
                "dateTimeRange": {
                    "regex": "none",
                    "alertText": "* অবৈধ",
                    "alertText2": "তারিখ সময় পরিসীমা"
                },
                "minSize": {
                    "regex": "none",
                    "alertText": "* সর্বনিম্ন",
                    "alertText2": "অক্ষর প্রয়োজন"
                },
                "maxSize": {
                    "regex": "none",
                    "alertText": "* সর্বোচ্চ",
                    "alertText2": "অক্ষর অনুমোদিত"
                },
		"groupRequired": {
                    "regex": "none",
                    "alertText": "* আপনাকে অবশ্যই নিম্নলিখিত ক্ষেত্রগুলির মধ্যে একটি পূরণ করতে হবে",
                    "alertTextCheckboxMultiple": "* একটি বিকল্প নির্বাচন করুন",
                    "alertTextCheckboxe": "* এই চেকবক্স প্রয়োজন"
                },
                "min": {
                    "regex": "none",
                    "alertText": "* সর্বনিম্ন মান হল"
                },
                "max": {
                    "regex": "none",
                    "alertText": "* সর্বোচ্চ মান"
                },
                "past": {
                    "regex": "none",
                    "alertText": "* আগের তারিখ"
                },
                "future": {
                    "regex": "none",
                    "alertText": "* তারিখ অতীত"
                },	
                "maxCheckbox": {
                    "regex": "none",
                    "alertText": "* সর্বোচ্চ",
                    "alertText2": "বিকল্প অনুমোদিত"
                },
                "minCheckbox": {
                    "regex": "none",
                    "alertText": "* অনুগ্রহ করে নির্বাচন করুন",
                    "alertText2": "বিকল্প"
                },
                "equals": {
                    "regex": "none",
                    "alertText": "* ক্ষেত্র মেলে না"
                },
                "creditCard": {
                    "regex": "none",
                    "alertText": "* ভুল ক্রেডিট কার্ড নাম্বার"
                },
                "phone": {
                    // credit: jquery.h5validate.js / orefalo
                    "regex": /^([\+][0-9]{1,3}([ \.\-])?)?([\(][0-9]{1,6}[\)])?([0-9 \.\-]{1,32})(([A-Za-z \:]{1,11})?[0-9]{1,4}?)$/,
                    "alertText": "* অবৈধ ফোন নম্বর"
                },
                "email": {
                    // HTML5 compatible email regex ( http://www.whatwg.org/specs/web-apps/current-work/multipage/states-of-the-type-attribute.html#    e-mail-state-%28type=email%29 )
                    "regex": /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/,
                    "alertText": "* অকার্যকর ইমেইল ঠিকানা"
                },
                "fullname": {
                    "regex":/^([a-zA-Z]+[\'\,\.\-]?[a-zA-Z ]*)+[ ]([a-zA-Z]+[\'\,\.\-]?[a-zA-Z ]+)+$/,
                    "alertText":"* প্রথম এবং শেষ নাম হতে হবে"
                },
                "zip": {
                    "regex":/^\d{5}$|^\d{5}-\d{4}$/,
                    "alertText":"* অবৈধ জিপ বিন্যাস"
                },
                "integer": {
                    "regex": /^[\-\+]?\d+$/,
                    "alertText": "* একটি বৈধ পূর্ণসংখ্যা নয়"
                },
                "number": {
                    // Number, including positive, negative, and floating decimal. credit: orefalo
                    "regex": /^[\-\+]?((([0-9]{1,3})([,][0-9]{3})*)|([0-9]+))?([\.]([0-9]+))?$/,
                    "alertText": "* অবৈধ ভাসমান দশমিক সংখ্যা"
                },
                "date": {                    
                    //	Check if date is valid by leap year
			"func": function (field) {
					var pattern = new RegExp(/^(\d{4})[\/\-\.](0?[1-9]|1[012])[\/\-\.](0?[1-9]|[12][0-9]|3[01])$/);
					var match = pattern.exec(field.val());
					if (match == null)
					   return false;
	
					var year = match[1];
					var month = match[2]*1;
					var day = match[3]*1;					
					var date = new Date(year, month - 1, day); // because months starts from 0.
	
					return (date.getFullYear() == year && date.getMonth() == (month - 1) && date.getDate() == day);
				},                		
			 "alertText": "* অবৈধ তারিখ, অবশ্যই YYYY-MM-DD ফর্ম্যাটে হতে হবে৷"
                },
                "ipv4": {
                    "regex": /^((([01]?[0-9]{1,2})|(2[0-4][0-9])|(25[0-5]))[.]){3}(([0-1]?[0-9]{1,2})|(2[0-4][0-9])|(25[0-5]))$/,
                    "alertText": "* Invalid IP address"
                },
                "url": {
                    "regex": /^(https?|ftp):\/\/(((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:)*@)?(((\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5])\.(\d|[1-9]\d|1\d\d|2[0-4]\d|25[0-5]))|((([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|\d|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.)+(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])*([a-z]|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])))\.?)(:\d*)?)(\/((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)+(\/(([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)*)*)?)?(\?((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|[\uE000-\uF8FF]|\/|\?)*)?(\#((([a-z]|\d|-|\.|_|~|[\u00A0-\uD7FF\uF900-\uFDCF\uFDF0-\uFFEF])|(%[\da-f]{2})|[!\$&'\(\)\*\+,;=]|:|@)|\/|\?)*)?$/i,
                    "alertText": "* অবৈধ আইপি ঠিকানা"
                },
                "onlyNumberSp": {
                    "regex": /^[0-9\ ]+$/,
                    "alertText": "* শুধুমাত্র সংখ্যা"
                },
                "onlyLetterSp": {
                    "regex": /^[a-zA-Z\ \u3300-\u9fff\uf900-\ufaff\u00C0-\u00ff\u0500-\u05FF']+$/,
                    "alertText": "* কেবল অক্ষর"
                },
				"onlyLetterAccentSp":{
                    "regex": /^[a-z\u00C0-\u017F\ ]+$/i,
                    "alertText": "* শুধুমাত্র অক্ষর (উচ্চারণ অনুমোদিত)"
                },
                "onlyLetterNumber": {
                    "regex": /^[0-9a-zA-Z]+$/,
                    "alertText": "* কোনো বিশেষ চিহ্ন গ্রহণযোগ্য নহে"
                },
                // --- CUSTOM RULES -- Those are specific to the demos, they can be removed or changed to your likings
				/* Change */
				"onlyLetterNumberSp": {
                    "regex": /^[0-9a-zA-Z\s-]+$/,
                    "alertText": "* কোনো বিশেষ চিহ্ন গ্রহণযোগ্য নহে"
                },
				/* end change */
                "ajaxUserCall": {
                    "url": "ajaxValidateFieldUser",
                    // you may want to pass extra data on the ajax call
                    "extraData": "name=eric",
                    "alertText": "* এই ব্যবহারকারী ইতিমধ্যে নেওয়া হয়েছে",
                    "alertTextLoad": "* যাচাই করা হচ্ছে, অনুগ্রহ করে অপেক্ষা করুন"
                },
				"ajaxUserCallPhp": {
                    "url": "phpajax/ajaxValidateFieldUser.php",
                    // you may want to pass extra data on the ajax call
                    "extraData": "name=eric",
                    // if you provide an "alertTextOk", it will show as a green prompt when the field validates
                    "alertTextOk": "* এই ইউজার নামটা প্রাপ্তিসাধ্য",
                    "alertText": "* এই ব্যবহারকারী ইতিমধ্যে নেওয়া হয়েছে",
                    "alertTextLoad": "* যাচাই করা হচ্ছে, অনুগ্রহ করে অপেক্ষা করুন"
                },
                "ajaxNameCall": {
                    // remote json service location
                    "url": "ajaxValidateFieldName",
                    // error
                    "alertText": "* এই নাম ইতিমধ্যে নেওয়া হয়েছে",
                    // if you provide an "alertTextOk", it will show as a green prompt when the field validates
                    "alertTextOk": "* এই নাম উপলব্ধ",
                    // speaks by itself
                    "alertTextLoad": "* যাচাই করা হচ্ছে, অনুগ্রহ করে অপেক্ষা করুন"
                },
				 "ajaxNameCallPhp": {
	                    // remote json service location
	                    "url": "phpajax/ajaxValidateFieldName.php",
	                    // error
	                    "alertText": "* এই নাম ইতিমধ্যে নেওয়া হয়েছে",
	                    // speaks by itself
	                    "alertTextLoad": "* যাচাই করা হচ্ছে, অনুগ্রহ করে অপেক্ষা করুন"
	                },
                "validate2fields": {
                    "alertText": "* হ্যালো ইনপুট করুন"
                },
	            //tls warning:homegrown not fielded 
                "dateFormat":{
                    "regex": /^\d{4}[\/\-](0?[1-9]|1[012])[\/\-](0?[1-9]|[12][0-9]|3[01])$|^(?:(?:(?:0?[13578]|1[02])(\/|-)31)|(?:(?:0?[1,3-9]|1[0-2])(\/|-)(?:29|30)))(\/|-)(?:[1-9]\d\d\d|\d[1-9]\d\d|\d\d[1-9]\d|\d\d\d[1-9])$|^(?:(?:0?[1-9]|1[0-2])(\/|-)(?:0?[1-9]|1\d|2[0-8]))(\/|-)(?:[1-9]\d\d\d|\d[1-9]\d\d|\d\d[1-9]\d|\d\d\d[1-9])$|^(0?2(\/|-)29)(\/|-)(?:(?:0[48]00|[13579][26]00|[2468][048]00)|(?:\d\d)?(?:0[48]|[2468][048]|[13579][26]))$/,
                    "alertText": "* অবৈধ তারিখ"
                },
                //tls warning:homegrown not fielded 
				"dateTimeFormat": {
	                "regex": /^\d{4}[\/\-](0?[1-9]|1[012])[\/\-](0?[1-9]|[12][0-9]|3[01])\s+(1[012]|0?[1-9]){1}:(0?[1-5]|[0-6][0-9]){1}:(0?[0-6]|[0-6][0-9]){1}\s+(am|pm|AM|PM){1}$|^(?:(?:(?:0?[13578]|1[02])(\/|-)31)|(?:(?:0?[1,3-9]|1[0-2])(\/|-)(?:29|30)))(\/|-)(?:[1-9]\d\d\d|\d[1-9]\d\d|\d\d[1-9]\d|\d\d\d[1-9])$|^((1[012]|0?[1-9]){1}\/(0?[1-9]|[12][0-9]|3[01]){1}\/\d{2,4}\s+(1[012]|0?[1-9]){1}:(0?[1-5]|[0-6][0-9]){1}:(0?[0-6]|[0-6][0-9]){1}\s+(am|pm|AM|PM){1})$/,
                    "alertText": "* অবৈধ তারিখ বা তারিখ বিন্যাস",
                    "alertText2": "প্রত্যাশিত বিন্যাস: ",
                    "alertText3": "mm/dd/yyyy hh: mm: ss AM | PM বা", 
                    "alertText4": "yyyy-mm-dd hh: mm: ss AM | PM"
	            }
            };
            
        }
    };

    $.validationEngineLanguage.newLang();
    
})(jQuery);
